package com.ejie.ab04b.webservice;

import javax.jws.HandlerChain;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

import com.ejie.ab04b.service.toolkit.ToolkitService;
import com.ejie.ab04b.service.util.ApplicationContextProvider;

/**
 * @author GFI-NORTE
 *
 */
@WebService(serviceName = "toolkitWebService", portName = "toolkitWebServicePort", targetNamespace = "http://com.ejie.ab04b.webservice")
@SOAPBinding(parameterStyle = ParameterStyle.WRAPPED)
@HandlerChain(file = "server-handlers.xml")
public class ToolkitWebService extends SpringBeanAutowiringSupport {

	private static final Logger LOGGER = LoggerFactory
			.getLogger(ToolkitWebService.class);

	/**
	 * Devuelve una lista con todas las opciones del tipo TipoObra.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaTipoObra() {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaTipoObra");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaTipoObra();
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo ApartadoAnexoI.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaApartadoAnexoI() {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaApartadoAnexoI");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaApartadoAnexoI();
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo ApartadoAnexoII.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaApartadoAnexoII() {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaApartadoAnexoII");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaApartadoAnexoII();
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo ClaseCentroTrabajo.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaClaseCentroTrabajo() {

		ToolkitWebService.LOGGER
				.info("Entra en obtenerListaClaseCentroTrabajo");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaClaseCentroTrabajo();
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo
	 * EntidadGestoraColaboradora.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaEntidadGestoraColaboradora() {

		ToolkitWebService.LOGGER
				.info("Entra en obtenerListaEntidadGestoraColaboradora");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaEntidadGestoraColaboradora();
	}

	/**
	 * Devuelve la descripción de una EntidadGestoraColaboradora.
	 * 
	 *  codEntidad            String
	 *  idioma            String
	 *  String
	 *
	 * @param codEntidad the cod entidad
	 * @param idioma the idioma
	 * @return the string
	 */
	@WebMethod()
	public String obtenerDescripcionEntidadGestoraColaboradora(
			String codEntidad, String idioma) {

		ToolkitWebService.LOGGER
				.info("Entra en obtenerDescripcionEntidadGestoraColaboradora");

		ToolkitWebService.LOGGER.info("CODENTIDAD0000 {}", codEntidad);

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerDescripcionEntidadGestoraColaboradora(
				codEntidad, idioma);
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo
	 * EntidadGestoraColaboradora.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaModalidadOrganizacionPreventiva() {

		ToolkitWebService.LOGGER
				.info("Entra en obtenerListaModalidadOrganizacionPreventiva");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaModalidadOrganizacionPreventiva();
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo EmpresaAuditora.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaEmpresaAuditora() {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaEmpresaAuditora");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaEmpresaAuditora();
	}

	/**
	 * Devuelve la descripción de una EmpresaAuditora.
	 * 
	 *  codEmpresa            String
	 *  idioma            String
	 *  String
	 *
	 * @param codEmpresa the cod empresa
	 * @param idioma the idioma
	 * @return the string
	 */
	@WebMethod()
	public String obtenerDescripcionEmpresaAuditora(String codEmpresa,
			String idioma) {

		ToolkitWebService.LOGGER
				.info("Entra en obtenerDescripcionEmpresaAuditora");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerDescripcionEmpresaAuditora(codEmpresa,
				idioma);
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo
	 * EmpresaServicioPrevencion.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaEmpresaServicioPrevencion() {

		ToolkitWebService.LOGGER
				.info("Entra en obtenerListaEmpresaServicioPrevencion");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaEmpresaServicioPrevencion();
	}

	/**
	 * Devuelve la descripción de una EmpresaServicioPrevencion.
	 * 
	 *  codEmpresa            String
	 *  idioma            String
	 *  String
	 *
	 * @param codEmpresa the cod empresa
	 * @param idioma the idioma
	 * @return the string
	 */
	@WebMethod()
	public String obtenerDescripcionEmpresaServicioPrevencion(String codEmpresa,
			String idioma) {

		ToolkitWebService.LOGGER
				.info("Entra en obtenerDescripcionEmpresaServicioPrevencion");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerDescripcionEmpresaServicioPrevencion(
				codEmpresa, idioma);
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo Pais.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaPais() {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaPais");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaPais();
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo Provincia.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaProvincia() {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaProvincia");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaProvincia();
	}

	/**
	 * Devuelve una lista con todas las opciones de Municipio de una Provincia.
	 * 
	 *  codProvincia            String
	 *  String
	 *
	 * @param codProvincia the cod provincia
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaMunicipioDeProvincia(String codProvincia) {

		ToolkitWebService.LOGGER.info(
				"Entra en obtenerListaMunicipioDeProvincia: {}", codProvincia);

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaMunicipioDeProvincia(codProvincia);
	}

	/**
	 * Devuelve una lista con todas las opciones de Localidad de un Municipio.
	 * 
	 *  codMunicipio            String
	 *  codProvincia            String
	 *  String
	 *
	 * @param codMunicipio the cod municipio
	 * @param codProvincia the cod provincia
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaLocalidadDeMunicipio(String codMunicipio,
			String codProvincia) {

		ToolkitWebService.LOGGER.info(
				"Entra en obtenerListaLocalidadDeMunicipio: {}, {}",
				codMunicipio, codProvincia);

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaLocalidadDeMunicipio(codMunicipio,
				codProvincia);
	}

	/**
	 * Devuelve una lista con todas las opciones de Calle de una Localidad.
	 * 
	 *  codLocalidad            String
	 *  String
	 *
	 * @param codLocalidad the cod localidad
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaCalleDeLocalidad(String codLocalidad) {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaCalleDeLocalidad");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaCalleDeLocalidad(codLocalidad);
	}

	/**
	 * Obtiene la serie documental correspondiente a cada territorio para
	 * realizar las solicitudes / aportaciones desde el toolkit.
	 * 
	 *  codProvincia            String
	 *  String
	 *
	 * @param codProvincia the cod provincia
	 * @return the string
	 */
	@WebMethod()
	public String obtenerSerieDocumental(String codProvincia) {

		ToolkitWebService.LOGGER.info("Entra en svtObtenerSerieDocumental");

		return codProvincia;
	}

	/**
	 * Obtiene el órgano gestor y el buzón correspondiente en función de cada
	 * territorio y de cada tipo de procedimiento para realizar las solicitudes
	 * / aportaciones desde el toolkit.
	 * 
	 *  codProvincia            String
	 *  procedureId            String
	 *  String
	 *
	 * @param codProvincia the cod provincia
	 * @param procedureId the procedure id
	 * @return the string
	 */
	@WebMethod()
	public String obtenerOrganoGestorYBuzon(String codProvincia,
			String procedureId) {

		ToolkitWebService.LOGGER.info("Entra en obtenerOrganoGestorYBuzon");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerOrganoGestorYBuzon(codProvincia,
				procedureId);
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo Seccion.
	 * 
	 *  String
	 *
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaSeccion() {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaSeccion");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaSeccion();
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo CnaeJ73.
	 * 
	 *  codSeccion            String
	 *  String
	 *
	 * @param codSeccion the cod seccion
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaDivision(String codSeccion) {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaDivision");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaDivision(codSeccion);
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo CnaeJ73.
	 * 
	 *  codSector            String
	 *  codDivision            String
	 *  String
	 *
	 * @param codSector the cod sector
	 * @param codDivision the cod division
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaCnae(String codSector, String codDivision) {

		ToolkitWebService.LOGGER
				.info("Entra en obtenerListaCnae {codSector, codDivision}");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaCnae(codSector, codDivision);
	}

	/**
	 * Devuelve una lista con todas las opciones del tipo CnaeJ73.
	 * 
	 *  cnae            String
	 *  String
	 *
	 * @param cnae the cnae
	 * @return the string
	 */
	@WebMethod()
	public String obtenerListaCnaeCodigo(String cnae) {

		ToolkitWebService.LOGGER.info("Entra en obtenerListaCnaeCodigo {cnae}");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.obtenerListaCnae(cnae);
	}

	/**
	 * Devuelve el código de CNAE si este existe.
	 * 
	 *  cnae            String
	 *  String
	 *
	 * @param cnae the cnae
	 * @return the string
	 */
	@WebMethod()
	public String autocompletarCnae(String cnae) {

		ToolkitWebService.LOGGER.info("Entra en autocompletarCnae");

		ApplicationContext applicationContext = ApplicationContextProvider
				.getApplicationContext();

		ToolkitService toolkitService = (ToolkitService) applicationContext
				.getBean("toolkitService");

		return toolkitService.autocompletarCnae(cnae);
	}

}